#include "derivative.h" /* include peripheral declarations */
#include "comm.h"


// define this to scale touch values to screen size (else they are 1024x1024)
//#define DEFAULT_640x480_CALIB

// define sample rate
#define SAMPLE_RATE_100_SEC         // note: this sample rate not really supported at 9600 bps serial
//#define SAMPLE_RATE_80_SEC
//#define SAMPLE_RATE_70_SEC
//#define SAMPLE_RATE_50_SEC

// must see pen-down stable for at least this many samples in a row
// note: this is dependent on the serial port speed, because at slower speeds we spend a 
// smaller fraction of the period in the debounce loop (ie. at 9600, 8 msec are spend
// transmitting, so only 2 msec are left over for debounce, assuming 100 pts/sec). We can
// read 200 times (easily) in 2 msec, which is the minumum debounce time (at 9600 baud).
#define debounce_count      200

#define sample_delay_usec   150                 //Time for ADC inputs to stabalize before reading

#define interval_1msec      125                 //8MHz bus clock/64 cycles per clock -> 125 ticks/msec
#define interval_2msec      250
#define interval_10msec     1250                //10 msec -> 100 sample/sec
#define interval_12_5msec   1563                //12.5 msec -> 80 samples/sec
#define interval_14_3msec   1786                //14.3 msec -> 70 samples/sec
#define interval_20msec     2500                //20 msec -> 50 samples/sec

// set the median filter size
#define MAX_MEDIAN_LEN      15
#define MEDIAN_LEN          5                   // should be odd

// setup the time slice based on the sample rate. Note that at 100 samples/sec, a serial rate of 9600 is
// too slow (8 msec to transmit, plus 2 msec for digitization), so we add an extra 2 msec to give a rate
// of about 80/sec
#ifdef SERIAL_BAUD_9600
#ifdef SAMPLE_RATE_100_SEC
#define TX_interval         interval_10msec
#endif
#endif

#ifndef TX_interval
#ifdef SAMPLE_RATE_100_SEC
#define TX_interval         interval_10msec
#endif
#ifdef SAMPLE_RATE_80_SEC
#define TX_interval         interval_12_5msec
#endif
#ifdef SAMPLE_RATE_70_SEC
#define TX_interval         interval_14_3msec
#endif
#ifdef SAMPLE_RATE_50_SEC
#define TX_interval         interval_20msec
#endif
#endif

// make sure some interval was chosen
#ifndef TX_interval
#error  Must define the TX interval 
#endif
   
#define wait_to_TX_clock TPM1CNT

/**************************************************************
Communication Control Bytes
**************************************************************/

#define TX_UA_TD   0x01  //Unaligned Data, Touch Detected
#define TX_UA_RD   0x09  //Unaligned Data, Release Detected
#define TX_AD_TD   0x03  //LCD Aligned Data, Touch Detected
#define TX_AD_RD   0x0B  //LCD Aligned Data, Release Detected

#define SERIAL_RX_SUPPORTED
#define RX_coeff   0x69  //'i' Implement the translation coefficients
#define TX_coeff   0x76  //'v' Verify the translation coefficients
#define RX_RS_CE   0x72  //'r' Reset the translation coefficients

/**************************************************************
Default Calibration Coefficients
   These may be either defined for a 640 x 480 screen, or 
   defined for "raw" touch data (1024 x 1024).
**************************************************************/

#ifdef DEFAULT_640x480_CALIB    //#define is at top of this file

// default to "calibrated" screen resolution (640 x 480)
#define Aprime_default  640
#define Bprime_default  0
#define Cprime_default  0
#define Dprime_default  0
#define Eprime_default  480
#define Fprime_default  0

#else

// default to "raw" touch values (1024 x 1024)
#define Aprime_default  1024
#define Bprime_default  0
#define Cprime_default  0
#define Dprime_default  0
#define Eprime_default  1024
#define Fprime_default  0

#endif
